REM General Settings and Introduction to user

echo off
setlocal EnableDelayedExpansion
set  specifyMem=N
set  configFile=DARconfig-2026.json
cd /d %~dp0
CLS
echo Hello! Welcome to the DAR command line tool. 
echo This command line tool is used for DAR Assessment and Patient Matching - Extract Pilots
echo Before you begin, please confirm three items.
echo    1^) You have extracted your patient and immunization file
echo    2^) Your patient and immunization files are located in the "IIS_file_extracts" folder
echo    3^) You know the name and extension of your patient and immunization files ^(e.g., patient.txt, imms.txt^)
echo.
echo Email AIRA at aart@immregistries.org with any questions! 
echo Please hit enter when you are ready. You can simply close out if you are not ready and come back later.
pause
echo.
echo.


REM Get user input for the content area and extracted files
set /p contentArea=Please confirm the measurement purpose ^(enter 1 for DAR Assessment or 2 for Patient Matching - Extract Pilot^):
set /p patientFileName=Please enter the name of your patient file ^(e.g., Patient.txt^):
set /p immunizationFileName=Please enter the name of your immunization file ^(e.g., Immunization.txt^):


if %contentArea% EQU 2 (
  set configFile=MPATconfig-pilot3-2026.json
)

REM A Restart point in the event an error could be recovered - See restart below
:restart

REM Actual command to kick off command line.
REM Two options to kick this off. 
REM    First with Java Memory being specified. 
REM    The second without. Default is without
if /I %specifyMem% == Y (
  java -jar -Xmx!memSize!g "nist_tooling\qdar-cli.jar" -p="IIS_file_extracts\%patientFileName%" -v="IIS_file_extracts\%ImmunizationFileName%" -c="nist_tooling\%configFile%" -pa
) else (
  java -jar "nist_tooling\qdar-cli.jar" -p="IIS_file_extracts\%patientFileName%" -v="IIS_file_extracts\%ImmunizationFileName%" -c="nist_tooling\%configFile%" -pa
)


REM Print an Error Code to screen if necessary. NOTE We are hiding Error 123 - Temp file clean up - and addressing that below to avoid end user confusion
if %ERRORLEVEL% GTR 0 (
  if NOT %ERRORLEVEL% EQU 123 ( 
    echo Error Code %ERRORLEVEL%
    echo %CD%
  )
)

:: if %ERRORLEVEL% GTR 0 (
:: 	echo Error Code %ERRORLEVEL%
:: 	echo %CD%
:: )

echo.
echo.
echo.
echo ^+========================================================================^+ 
echo ^|==========================      RESULTS     ============================^|
echo ^+========================================================================^+
if %ERRORLEVEL% EQU 0 (
	echo We have been able to successfully parse your patient and immunization file, but you are not out of the woods yet
	echo Please review the darq-analysis/summary/index.html file to verify the following sections
	echo    1^) Summary Counts: These should reflect counts of the data you extracted.
	echo    2^) Age Groups: These should reflect the distribution of your age cohorts.
	echo    3^) Extraction Completeness: The percentages by field reflect the data you extacted.
	echo.
	echo Once you have verified the above information, please log into AART and upload your "darq-analysis/ADF.data" file
	echo Please save your "darq-analysis" folder and data. You'll utilize this later on.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% EQU 101 (
	echo We were unable to find the following file:
	echo   1^) patient file: IIS_file_extracts\%patientFileName%
	echo.
	echo Please double-check:
	echo   1^) The spelling of the filename and extension closely
	echo   2^) The patient file must be in the "IIS_file_extracts" folder
        echo.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% EQU 102 (
	echo We were unable to find the following file:
	echo   1^) immunization file: IIS_file_extracts\%ImmunizationFileName%
	echo.
	echo Please double-check:
	echo   1^) The spelling of the filename and extension closely
	echo   2^) The immunization file must be in the "IIS_file_extracts" folder
        echo.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% EQU 103 (
	echo We were unable to find the following files:
	echo   1^) patient file: IIS_file_extracts\%patientFileName%
	echo   2^) immunization file: IIS_file_extracts\%ImmunizationFileName%
	echo.
	echo Please double-check:
	echo   1^) The spelling of the filenames and extensions closely
	echo   2^) Both files must be in the "IIS_file_extracts" folder
        echo.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% EQU 121 (
	echo This tooling needs a bit more memory. 
	echo Every system is different so no single value will work for everyone.
	echo We often suggest starting with a value of 1 or 2 and continuing higher if you see the same error.
	set /p memSize=Please enter a number as a single digit with no letters ^(e.g., 1, 2, 4, 6, 8, 10^):
	set  specifyMem=Y
        echo.
        goto :restart
)
if %ERRORLEVEL% EQU 123 (
	echo We have been able to successfully parse your patient and immunization file.
	echo However, we ran into a problem removing some temporary files that you should delete.
	echo Please delete any newly created random-character folders ^(e.g., 8d6wSGuBDC, kXXKQl3MYm^)
	echo.
	echo Please review the darq-analysis/summary/index.html file to verify the following sections
	echo    1^) Summary Counts: These should reflect counts of the data you extracted.
	echo    2^) Age Groups: These should reflect the distribution of your age cohorts.
	echo    3^) Extraction Completeness: The percentages by field reflect the data you extacted.
	echo.
	echo Once you have verified the above information, please log into AART and upload your "darq-analysis/ADF.data" file
	echo Please save your "darq-analysis" folder and data. You'll utilize this later on.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% EQU 124 (
	echo There appears to be errors in your patient or immunization file.
	echo These issues can be found in the darq-analysis/summary/index.html file.
	echo Once the issues have been resolved, please re-run this tool.
        echo.
        echo please email AIRA at aart@immregistries.org for further guidance if you are unable to resolve all errors. 
        goto :done
)
if %ERRORLEVEL% EQU 125 (
	echo The patient or immunization file is not saved with UTF-8 encoding.
	echo Please open your files in Notepad ^(or similar^) and change the Encoding Type to UTF-8 via File ^-^> Save As.
	echo See the troubleshooting section of the User Guide for more detailed instructions.
        echo.
        echo Please email AIRA at aart@immregistries.org if you have any questions or need assistance. 
        goto :done
)
if %ERRORLEVEL% GTR 103 (
	echo We have encountered an unusual error. 
	echo Please email AIRA at aart@immregistries.org with a screen shot of this screen to help with troubleshooting.
)

:done
echo.

pause
